/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transport;

import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;

public abstract class SipMessage {
    protected String sipVersion = "SIP/2.0";
    protected SipHeaders sipHeaders = new SipHeaders();
    protected byte[] body;

    public String getSipVersion() {
        return this.sipVersion;
    }

    public void setSipHeaders(SipHeaders sipHeaders) {
        this.sipHeaders = sipHeaders;
    }

    public SipHeaders getSipHeaders() {
        return this.sipHeaders;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        SipHeaderFieldName contentLengthName = new SipHeaderFieldName("Content-Length");
        SipHeaderFieldValue contentLengthValue = this.sipHeaders.get(contentLengthName);
        if (contentLengthValue == null) {
            contentLengthValue = new SipHeaderFieldValue(String.valueOf(body.length));
            this.sipHeaders.add(contentLengthName, contentLengthValue);
        } else {
            contentLengthValue.setValue(String.valueOf(body.length));
        }
        this.body = body;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.sipHeaders.toString());
        buf.append("\r\n");
        if (this.body != null) {
            buf.append(new String(this.body));
        }
        return buf.toString();
    }
}

